/*************************************************************************
 * The contents of this file are subject to the MYRICOM MX AND GM-2      *
 * MAPPING SOFTWARE AND DOCUMENTATION LICENSE (the "License"); User may  *
 * not use this file except in compliance with the License.  The full    *
 * text of the License can found in mapper directory in LICENSE.TXT      *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef mi_h
#define mi_h

#ifdef	__cplusplus
extern "C"
{
#endif

#include <stdlib.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

#define MI_MY_SIZE 2
#define MI_POLL_USECS 0

typedef unsigned mi_u32_t;
typedef unsigned char mi_u8_t;
typedef signed char mi_s8_t;
typedef unsigned short mi_u16_t;

#define mi_htonl(s)s
#define mi_htons(s)s

extern int mi_verbose_flag;
void mi_println_verbose_function (const char*fmt,...);
#define mi_c(p) if (mi_verbose_flag) mi_println_verbose_function p

typedef struct lx_node_t*mi_index_t;
struct lx_node_t;
struct lx_t;

typedef struct mi_t
{
  int nothing;
}mi_t;

typedef unsigned mi_weight_t;

typedef struct mi_hop_t
{
  struct lx_node_t*node;
  struct lx_node_t*root;
  int iport;
  struct lx_route_t*route;
}mi_hop_t;
  
typedef struct mi_node_data_t
{
  int counts [LX_XBAR_SIZE];
  mi_hop_t hops [LX_XBAR_SIZE] [LX_XBAR_SIZE];
  int seen [LX_XBAR_SIZE];
}mi_node_data_t;


#define mi_index2node(index)index
#define mi_node2index(n)n
void mi_fail (void);

#define insist(e) if(!(e)) {printf ("assertion failed. %s:%d (%s)\n", __FILE__,__LINE__, #e); mi_fail (); goto except;}

#define mi_rand lx_rand
#define mi_memcpy memcpy

#define mi_match(i,a,b)1
#define mi_punt(lx)
#define mi_printeur_lx 0

int mi_print_hops (FILE*fp, struct lx_node_t*n, struct lx_node_t*to, int iport, int oport, struct lx_route_t*r);

#ifdef __cplusplus
#if 0
{
#endif
}
#endif


#endif /*mi_h*/
